let jwt = require('jsonwebtoken');
const Admin = require('../../models/admins');
const config = require('../../../configs/jwt.configs.js');

let checkToken = (req, res, next) => {
  let token = req.headers['x-access-token'] || req.headers['authorization']; // Express headers are auto converted to lowercase
  if (token && token.startsWith('Bearer ')) {
    // Remove Bearer from string
    token = token.slice(7, token.length);
  }

  if (token) {
    jwt.verify(token, config.secret, async(err, decoded) => {
      if (err) {
        return res.status(401).json({
          success: false,
          message: 'Token is not valid'
        });
      } else { 
        let admin = await Admin.findById(decoded._id);
        if(!admin) {
          return res.status(401).json({success: false, message: 'Token is not valid for this route request.'});
        } else {
          req.admin = decoded;
          next();
        }          
      }
    });
  } else {
    return res.status(401).json({
      success: false,
      message: 'Auth token is not supplied'
    });
  }
};

module.exports = {
  checkToken: checkToken
}