const express = require('express');
const router = express.Router();
const { param } = require("express-validator");
const { createAppointmentValidation, updateAppointmentValidation } = require("../../utils/ApiValidation/appointment");
const { handleValidationErrors } = require("../../utils/errors");
const appointmentAction = require('../actions/appointment.action');
const driverUserMiddleware = require('../middlewares/driver_users.middleware.js');

router
	.post('/:orderId',
        driverUserMiddleware.checkToken,
        param('orderId').isMongoId().withMessage('Params id must be valid mongo Id.'),
        createAppointmentValidation,
		handleValidationErrors,
		appointmentAction.create
	)

    .get(
		'/',
        driverUserMiddleware.checkToken, 
		appointmentAction.list
	)

    .get(
		'/:id', 
		driverUserMiddleware.checkToken,
		param('id').isMongoId().withMessage('Params id must be valid mongo Id.'),
		handleValidationErrors,  
		appointmentAction.appointmentDetails
	)
	.put(
		'/:id',
		driverUserMiddleware.checkToken,
		param('id').isMongoId().withMessage('Params id must be valid mongo Id.'),
		updateAppointmentValidation,
		handleValidationErrors, 
		appointmentAction.update
	)
	.delete(
		'/:id', 
		driverUserMiddleware.checkToken,
		param('id').isMongoId().withMessage('Params id must be valid mongo Id.'),
		handleValidationErrors, 
		appointmentAction.destroy
	)

module.exports = router