const mongoose = require('mongoose');

const Schema = mongoose.Schema;

const AdminsSchema = new Schema({
    firstName: {
        type: String,
        required: true
    },
    lastName: {
        type: String,
        required: true
    },
    email: {
        type: String,
        required: true
    },

    phone: {
        type: String,
        required: false,
    },

    password: {
        type: String,
        required: true
    },
    
    isActive: {
        type: Boolean,
        default: false
    },

    isApproved: {
        type: Boolean,
        default: false
    },
    
    physicalAddress: {
        street: { type: String, required: true },
        city: { type: String, required: true },
        state: { type: String, required: true },
        zip: { type: String, required: true },
    },

    mailingAddress: {
        street: { type: String, required: true },
        city: { type: String, required: true },
        state: { type: String, required: true },
        zip: { type: String, required: true },
    },

    createdAt: {
        type: Date,
        default: Date.now
    },
    updatedAt: {
        type: Date,
        default: Date.now
    },
    createdBy: { type : Schema.Types.ObjectId, required: false },
    updatedBy: { type : Schema.Types.ObjectId, required: false }
});

AdminsSchema.methods.setCreatedBy = function(admin) {
    return this.createdBy = admin;
}

AdminsSchema.methods.setUpdatedBy = function(admin) {
    return this.updatedBy = admin;
}

AdminsSchema.methods.setUpdatedAt = function() {
    return this.updatedAt = new Date();
}


module.exports = mongoose.model('Admin', AdminsSchema);
