const mongoose = require('mongoose');
const Schema = mongoose.Schema;
const OrdersSchema = new Schema({
    provider: {
        type: Schema.Types.ObjectId,
        ref: 'Provider',
        required: true
    },

    driver: {
        type: Schema.Types.ObjectId,
        ref: 'Driver',
        required: true
    },

    payment: {
        type: Schema.Types.ObjectId,
        ref: 'Payment',
        required: true
    },

    status: {
        type: String,
        required: true
    },

    dateOfExam: {
        type: Date,
        required: false
    },

    certificateExpirationDate: {
        type: Date,
        required: false
    },

    isOrderCompleted: {
        type: Boolean,
        default: false,
    },

    isOrderDisqualified: {
        type: Boolean,
        default: false,
    },

    isOrderDeterminationPending: {
        type: Boolean,
        default: false,
    },

    disqualifiedReason: {
        type: String,
        required: false,
    },

    determinationPendingReason: {
        type: String,
        required: false,
    },
    
    uuid: {
        type: String,
        required: true
    },

    token: {
        type: String,
        required: false
    },


    createdAt: {
        type: Date,
        default: Date.now
    },
    updatedAt: {
        type: Date,
        default: Date.now
    },
    createdBy: { type : Schema.Types.ObjectId, required: false },
    updatedBy: { type : Schema.Types.ObjectId, required: false }
});

OrdersSchema.methods.setCreatedBy = function(driver) {
    return this.createdBy = driver;
}

OrdersSchema.methods.setUpdatedBy = function(driver) {
    return this.updatedBy = driver;
}

OrdersSchema.methods.setUpdatedAt = function() {
    return this.updatedAt = new Date();
}


module.exports = mongoose.model('Order', OrdersSchema);
