const mongoose = require('mongoose');
const Schema = mongoose.Schema;
const AppointmentsSchema = new Schema({
    schedule: {
        type: Schema.Types.ObjectId,
        ref: 'Schedule',
        required: true
    },

    provider: {
        type: Schema.Types.ObjectId,
        ref: 'Provider',
        required: true
    },

    driver: {
        type: Schema.Types.ObjectId,
        ref: 'Driver',
        required: true
    },

    order: {
        type: Schema.Types.ObjectId,
        ref: 'Order',
        required: true
    },

    appointmentType: {
        type: String,
        default: 'created',
        required: true
    },

    status: {
        type: String,
        required: true
    },
    
    uuid: {
        type: String,
        required: true
    },

    createdAt: {
        type: Date,
        default: Date.now
    },
    updatedAt: {
        type: Date,
        default: Date.now
    },
    createdBy: { type : Schema.Types.ObjectId, required: false },
    updatedBy: { type : Schema.Types.ObjectId, required: false }
});

AppointmentsSchema.methods.setCreatedBy = function(driver) {
    return this.createdBy = driver;
}

AppointmentsSchema.methods.setUpdatedBy = function(driver) {
    return this.updatedBy = driver;
}

AppointmentsSchema.methods.setUpdatedAt = function() {
    return this.updatedAt = new Date();
}


module.exports = mongoose.model('Appointment', AppointmentsSchema);
