const { body } = require("express-validator");

const createPaymentValidation = [
    body("provider").exists().withMessage("Provider Id is required.").isMongoId().withMessage('Provider Id must be valid mongoId.'),

    body("billingAddress").exists().withMessage("Billing address is required."),
    body("billingAddress.street").exists().withMessage("Billing address street is required."),
    body("billingAddress.city").exists().withMessage("Billing address city is required."),
    body("billingAddress.state").exists().withMessage("Billing address state is required."),
    body("billingAddress.zip").exists().withMessage("Billing address zip is required."),

    body("amount").exists().withMessage("Amount is required.").isInt().withMessage('Amount must be Numeric'),
    body("paymentMethod").exists().withMessage("Payment method is required."),
]




module.exports = {
    createPaymentValidation,
}

