const express = require('express');
const router = express.Router();
const { param } = require("express-validator");
const { createPaymentValidation } = require("../../utils/ApiValidation/payment");
const { handleValidationErrors } = require("../../utils/errors");
const paymentAction = require('../actions/payment.action');
const driverUserMiddleware = require('../middlewares/driver_users.middleware.js');

router
	.get('/create-stripe-payment-intent',
		paymentAction.stripePaymentInitialization
	)

	.post('/create-payment-order',
		paymentAction.createPaymentOrder
	)

	.post('/',
        driverUserMiddleware.checkToken,
        createPaymentValidation,
		handleValidationErrors,
		paymentAction.create
	)

	.get('/',
        driverUserMiddleware.checkToken,
		paymentAction.list
	)

	.get(
		'/:id', 
		driverUserMiddleware.checkToken,
		param('id').isMongoId().withMessage('Params id must be valid mongo Id.'),
		handleValidationErrors,  
		paymentAction.paymentDetails
	)

	.get('/orders/list',
        driverUserMiddleware.checkToken,
		paymentAction.ordersList
	)

	.get(
		'/orders/:id', 
		driverUserMiddleware.checkToken,
		param('id').isMongoId().withMessage('Params id must be valid mongo Id.'),
		handleValidationErrors,  
		paymentAction.orderDetails
	)

module.exports = router