const mongoose = require('mongoose');
const Schema = mongoose.Schema;
const ProvidersSchema = new Schema({
    companyName: {
        type: String,
        required: true
    },
    mainContactFirstName: {
        type: String,
        required: true
    },
    mainContactLastName: {
        type: String,
        required: true
    },
    certifiedMedicalExaminarFirstName: {
        type: String,
        required: true
    },
    certifiedMedicalExaminarLastName: {
        type: String,
        required: true
    },
    email: {
        type: String,
        required: true
    },

    phone: {
        type: String,
        required: true,
    },

    password: {
        type: String,
        required: true
    },
    
    isVerified: {
        type: Boolean,
        default: false
    },

    isApproved: {
        type: Boolean,
        default: false
    },

    testPrice: {
        type: Number,
        default: 0,
        required: true
    },

    physicalAddress: {
        street: { type: String, required: true },
        city: { type: String, required: true },
        state: { type: String, required: true },
        zip: { type: String, required: true },
    },

    mailingAddress: {
        street: { type: String, required: true },
        city: { type: String, required: true },
        state: { type: String, required: true },
        zip: { type: String, required: true },
    },

    addressCoordinates: {
        latitude: "",
        longitude:"",
        place_id: ""
    },

    nrcmeNo: {
        type: Number,
        required: true
    },

    nrcmeExpirationDate: {
        type: Date,
        required: true
    },

    onlineAppointmentCalendarLink: {
        type: String,
        required: false,
    },

    practitionerType: {
        type: String,
        enum: {
            values: ['MD', 'PA', 'NP', 'DC'],
            message: '{VALUE} is not supported'
        },
        required: true
    },

    appointmentType: {
        type: String,
        enum: {
            values: ['walkin', 'appointment', 'both'],
            message: '{VALUE} is not supported'
        },
        required: true
    },

    providerType: {
        type: String,
        enum: {
            values: ['preferred', 'oon']
        },
        required: true
    },

    token: {
        type: String,
        required: false
    },

    createdAt: {
        type: Date,
        default: Date.now
    },
    updatedAt: {
        type: Date,
        default: Date.now
    },
    createdBy: { type : Schema.Types.ObjectId, required: false },
    updatedBy: { type : Schema.Types.ObjectId, required: false }
});

ProvidersSchema.methods.setCreatedBy = function(provider) {
    return this.createdBy = provider;
}

ProvidersSchema.methods.setUpdatedBy = function(provider) {
    return this.updatedBy = provider;
}

ProvidersSchema.methods.setUpdatedAt = function() {
    return this.updatedAt = new Date();
}


module.exports = mongoose.model('Provider', ProvidersSchema);
