const express = require('express');
const path = require('path');
const mongoose = require('mongoose');
const morgan = require('morgan');
const db = require('./configs/database.config');
const app = express();

//Configure mongoose's promise to global promise
mongoose.promise = global.Promise;

//Configure isProduction variable
const isProduction = process.env.NODE_ENV === 'production';

app.use(morgan('combined'));
app.use(express.json());
app.use(express.urlencoded({ extended: false }));
app.use(express.static(path.join(__dirname, 'public')));


app.use(function(req, res, next) {
  const allowedOrigins = ['http://localhost:3000', 'http://127.0.0.1:3000', 'https://dotphys-admin.herokuapp.com', 'https://dotphys-provider.herokuapp.com', 'https://dotphys-driver.herokuapp.com'];
  const origin = req.headers.origin;
  if (allowedOrigins.includes(origin)) {
    res.setHeader('Access-Control-Allow-Origin', origin);
  }
  // res.setHeader('Access-Control-Allow-Origin', '*');
  res.header('Access-Control-Allow-Methods', 'GET, PUT, PATCH, POST, DELETE, HEAD, OPTIONS');
  res.header('Access-Control-Allow-Headers', 'Content-Type, Authorization');
  res.header('Access-Control-Allow-Credentials', true);
  res.header('Access-Control-Expose-Headers', 'Authorization');
  return next();
});


require('dotenv').config();

//Configure Mongoose
mongoose.connect(db.url, {
  useNewUrlParser: true,
  useFindAndModify: false,
  useUnifiedTopology: true
})
console.log('Mongodb Connected Successfully');

const apiPrefix = process.env.API_PREFIX

// ------------------ importing route files ------------------------
const adminUsersRouter = require('./app/http/routes/admin_users.route');
const providerUsersRouter = require('./app/http/routes/provider_users.route');
const driverUsersRouter = require('./app/http/routes/driver_users.route');
const paymentRouter = require('./app/http/routes/payment.route');
const appointmentRouter = require('./app/http/routes/appointment.route');
const scheduleRouter = require('./app/http/routes/schedule.route');

//------------------------ api routes -------------------------------
app.use(apiPrefix + '/admin/users', adminUsersRouter)
app.use(apiPrefix + '/provider/users', providerUsersRouter)
app.use(apiPrefix + '/driver/users', driverUsersRouter)
app.use(apiPrefix + '/driver/payment', paymentRouter)
app.use(apiPrefix + '/driver/appointment', appointmentRouter)
app.use(apiPrefix + '/schedule', scheduleRouter)

module.exports = app